%% Code to generate Fig 4b
% Path gain estimation error vs SNR

clear all
close all
clc

aspread_aoa_set = [10;30;60]; 
case_val = 0;

aspread_aoa = aspread_aoa_set(1);
file_load = ['Fig4_Fig5_aspread_',num2str(aspread_aoa),'cval_',num2str(case_val),'.mat'];
load(file_load);
figure
plot(SNR_dB, 10*log10(MSE_a_gain), 'r--o','LineWidth',1.2)
hold on
plot(SNR_dB, 10*log10(MSE_sd_gain), 'b-o','LineWidth',1.2)
hold on


aspread_aoa = aspread_aoa_set(2);
file_load = ['Fig4_Fig5_aspread_',num2str(aspread_aoa),'cval_',num2str(case_val),'.mat'];
load(file_load);
plot(SNR_dB, 10*log10(MSE_a_gain), 'r--*','LineWidth',1.2)
hold on
plot(SNR_dB, 10*log10(MSE_sd_gain), 'b-*','LineWidth',1.2)
hold on

aspread_aoa = aspread_aoa_set(3);
file_load = ['Fig4_Fig5_aspread_',num2str(aspread_aoa),'cval_',num2str(case_val),'.mat'];
load(file_load);
plot(SNR_dB, 10*log10(MSE_a_gain), 'r--s','LineWidth',1.2)
hold on
plot(SNR_dB, 10*log10(MSE_sd_gain), 'b-s','LineWidth',1.2)
hold on

legend('UQ - 10^{0}','SD - 10^{0}', 'UQ - 30^{0}','SD - 30^{0}', 'UQ - 60^{0}','SD - 60^{0}');
xlabel('SNR (dB)')
ylabel('Path gain NMSE (dB)')
grid on
xlim([-15 15])
savefig('Fig4b.fig')
saveas(gcf,'Fig4b','epsc')

